﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private accentBrush As Brush


    Public Sub New()
        InitializeComponent()
        accentBrush = TryCast(Me.Resources("PhoneAccentBrush"), Brush)

        ' Get all assemblies
        Dim assemblies As New List(Of System.Reflection.Assembly)()
        assemblies.Add(System.Reflection.Assembly.Load("System.Windows"))
        assemblies.Add(System.Reflection.Assembly.Load("Microsoft.Phone"))
        assemblies.Add(System.Reflection.Assembly.Load("Microsoft.Phone.Controls"))
        assemblies.Add(System.Reflection.Assembly.Load("Microsoft.Phone.Controls.Maps"))

        ' Set root object (use DependencyObject for shorter list)
        Dim typeRoot = GetType(Object)

        ' Assemble total list of public classes
        Dim classes As New List(Of Type)()
        classes.Add(typeRoot)

        For Each [assembly] As System.Reflection.Assembly In assemblies
            For Each type In [assembly].GetTypes()
                If type.IsPublic AndAlso type.IsSubclassOf(typeRoot) Then
                    classes.Add(type)
                End If
            Next type
        Next [assembly]

        ' Sort those classes
        classes.Sort(AddressOf TypeCompare)

        ' Now put all those sorted classes into a tree structure
        Dim rootClass As New ClassAndChildren(typeRoot)
        AddToTree(rootClass, classes)

        ' Display the tree
        Display(rootClass, 0)
    End Sub


    Private Function TypeCompare(ByVal t1 As Type, ByVal t2 As Type) As Integer
        Return String.Compare(t1.Name, t2.Name)
    End Function


    ' Recursive method
    Private Sub AddToTree(ByVal parentClass As ClassAndChildren, ByVal classes As List(Of Type))
        For Each type As Type In classes
            If type.BaseType Is parentClass.Type OrElse
                (type.BaseType IsNot Nothing AndAlso type.BaseType.IsGenericType AndAlso
                 (Not type.BaseType.IsGenericTypeDefinition) AndAlso
                 type.BaseType.GetGenericTypeDefinition() Is parentClass.Type) Then
                Dim subClass As New ClassAndChildren(type)
                parentClass.SubClasses.Add(subClass)
                AddToTree(subClass, classes)
            End If
        Next type
    End Sub


    ' Recursive method
    Private Sub Display(ByVal parentClass As ClassAndChildren, ByVal indent As Integer)
        Dim str1 = String.Format("{0}{1}{2}{3}",
                                 New String(" "c, indent * 4),
                                 parentClass.Type.Name,
                                 If(parentClass.Type.IsAbstract, " (abstract)", ""),
                                 If(parentClass.Type.IsSealed, " (sealed)", ""))

        Dim str2 = " " & parentClass.Type.Namespace

        Dim txtblk As New TextBlock()
        txtblk.Inlines.Add(str1)
        txtblk.Inlines.Add(New Run With {.Text = str2, .Foreground = accentBrush})

        stackPanel.Children.Add(txtblk)

        For Each child As ClassAndChildren In parentClass.SubClasses
            Display(child, indent + 1)
        Next child
    End Sub
End Class
